/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import cz.insophy.inplan.export.csv.CompatibilityCsvTableWriter;
import cz.insophy.inplan.export.csv.CompatibilityReader;
import cz.insophy.inplan.export.csv.CsvFormatter;
import cz.insophy.inplan.export.csv.CsvTableWriter;
import cz.insophy.inplan.util.UnicodeBOMInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class CsvFormat {
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final char DEFAULT_SEPARATOR = CSVFormat.DEFAULT.getDelimiter();
    public static final String DEFAULT_ROW_END = CSVFormat.DEFAULT.getRecordSeparator();
    public static final char DEFAULT_QUOTE = CSVFormat.DEFAULT.getQuoteCharacter().charValue();
    public static final char DEFAULT_ESCAPE = '\\';
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = CSVFormat.DEFAULT.getIgnoreSurroundingSpaces();
    public static final boolean DEFAULT_DO_QUOTING = true;
    public static final boolean DEFAULT_FIRST_ROW_IS_HEADERS = true;
    public static final boolean DEFAULT_COMPATIBILITY_MODE = false;
    public static final boolean DEFAULT_ZERO_DATE_AS_NULL = false;
    private String charset;
    private char separator;
    private String rowEnd;
    private char quotechar;
    private char escape;
    private boolean strictQuotes;
    private boolean ignoreLeadingWhitespace;
    private boolean doQuoting;
    private boolean firstRowIsHeader;
    private char decimalSeparator;
    private String thousandsSeparator;
    private int fractionalDigits;
    private String dateFormat;
    private String timeFormat;
    private String datetimeFormat;
    private boolean compatibilityMode;
    private boolean zeroDateAsNull;

    public static CsvFormat createDefaultFormat() {
        return new CsvFormat();
    }

    public static CsvFormat createCompatibilityDefaultFormat() {
        return new CsvFormat(DEFAULT_CHARSET, ',', '\"', '\\', false, '.', ",", -1, "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss", false, true, "\n", true, true, false);
    }

    public static CsvFormat createCzechFormat() {
        return new CsvFormat("windows-1250", ';', '\"', '\\', true, ',', "", -1, "dd.MM.yyyy", "HH:mm:ss", "dd.MM.yyyy HH:mm:ss", false, true, "\r\n", true, false, false);
    }

    public static CsvFormat createCompatibilityCzechFormat() {
        return new CsvFormat("windows-1250", ';', '\"', '\\', true, ',', "", -1, "dd.MM.yyyy", "HH:mm:ss", "dd.MM.yyyy HH:mm:ss", false, true, "\r\n", true, true, false);
    }

    public CsvFormat() {
        this(DEFAULT_CHARSET, ',', '\"', '\\', false, '.', ",", -1, "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss", false, true, "\n", true, false, false);
    }

    public CsvFormat(String charset, char separator, char quotechar, char escape, boolean firstRowIsHeader, char decimalSeparator, String thousandsSeparator, int fractionalDigits, String dateFormat, String timeFormat, String datetimeFormat, boolean strictQuotes, boolean ignoreLeadingWhitespace, String rowEnd, boolean doQuoting, boolean compatibilityMode, boolean zeroDateAsNull) {
        this.charset = charset;
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.firstRowIsHeader = firstRowIsHeader;
        this.decimalSeparator = decimalSeparator;
        this.thousandsSeparator = thousandsSeparator;
        this.fractionalDigits = fractionalDigits;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.datetimeFormat = datetimeFormat;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhitespace = ignoreLeadingWhitespace;
        this.rowEnd = rowEnd;
        this.doQuoting = doQuoting;
        this.compatibilityMode = compatibilityMode;
        this.zeroDateAsNull = zeroDateAsNull;
    }

    public boolean isFirstRowIsHeader() {
        return this.firstRowIsHeader;
    }

    public String getCharset() {
        return this.charset;
    }

    public CSVParser createReader(InputStream input) throws NullPointerException, IOException {
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(input);
        ubis.skipBOM();
        Reader reader = new BufferedReader(new InputStreamReader((InputStream)ubis, this.charset));
        if (this.compatibilityMode) {
            reader = new CompatibilityReader(reader, this.escape, this.quotechar);
        }
        return new CSVParser(reader, CSVFormat.newFormat(this.separator).withIgnoreEmptyLines(true).withQuote(this.doQuoting ? Character.valueOf(this.quotechar) : null).withEscape(this.escape).withSkipHeaderRecord(false).withIgnoreSurroundingSpaces(this.ignoreLeadingWhitespace));
    }

    public CsvTableWriter createWriter(OutputStream output) throws IOException {
        CSVFormat format = CSVFormat.newFormat(this.separator).withIgnoreEmptyLines(true).withQuote(this.quotechar).withEscape(this.escape).withRecordSeparator(this.rowEnd).withQuoteMode(this.doQuoting ? QuoteMode.ALL : QuoteMode.NONE);
        if (this.compatibilityMode) {
            format = format.withQuote(null).withEscape(null).withQuoteMode(QuoteMode.MINIMAL);
            CSVPrinter printer = new CSVPrinter(new BufferedWriter(new OutputStreamWriter(output, this.charset)), format);
            return CompatibilityCsvTableWriter.createWriter(printer, this.createFormatter(), this);
        }
        CSVPrinter printer = new CSVPrinter(new BufferedWriter(new OutputStreamWriter(output, this.charset)), format);
        return new CsvTableWriter(printer, this.createFormatter());
    }

    public CsvFormatter createFormatter() {
        boolean useUnicodeSymbols = this.charset.toLowerCase().startsWith("utf");
        return new CsvFormatter(this.decimalSeparator, this.thousandsSeparator, this.fractionalDigits, this.dateFormat, this.timeFormat, this.datetimeFormat, useUnicodeSymbols, this.zeroDateAsNull);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String getRowEnd() {
        return this.rowEnd;
    }

    public void setRowEnd(String rowEnd) {
        this.rowEnd = rowEnd;
    }

    public char getQuotechar() {
        return this.quotechar;
    }

    public void setQuotechar(char quotechar) {
        this.quotechar = quotechar;
    }

    public char getEscape() {
        return this.escape;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public boolean isStrictQuotes() {
        return this.strictQuotes;
    }

    public void setStrictQuotes(boolean strictQuotes) {
        this.strictQuotes = strictQuotes;
    }

    public boolean isIgnoreLeadingWhitespace() {
        return this.ignoreLeadingWhitespace;
    }

    public void setIgnoreLeadingWhitespace(boolean ignoreLeadingWhitespace) {
        this.ignoreLeadingWhitespace = ignoreLeadingWhitespace;
    }

    public boolean isDoQuoting() {
        return this.doQuoting;
    }

    public void setDoQuoting(boolean doQuoting) {
        this.doQuoting = doQuoting;
    }

    public void setFirstRowIsHeader(boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public String getThousandsSeparator() {
        return this.thousandsSeparator;
    }

    public void setThousandsSeparator(String thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
    }

    public int getFractionalDigits() {
        return this.fractionalDigits;
    }

    public void setFractionalDigits(int fractionalDigits) {
        this.fractionalDigits = fractionalDigits;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    public boolean isZeroDateAsNull() {
        return this.zeroDateAsNull;
    }

    public void setZeroDateAsNull(boolean zeroDateAsNull) {
        this.zeroDateAsNull = zeroDateAsNull;
    }

    public String toString() {
        return "CsvFormat{charset='" + this.charset + "', separator=" + this.separator + ", rowEnd='" + this.rowEnd + "', quotechar=" + this.quotechar + ", escape=" + this.escape + ", strictQuotes=" + this.strictQuotes + ", ignoreLeadingWhitespace=" + this.ignoreLeadingWhitespace + ", doQuoting=" + this.doQuoting + ", firstRowIsHeader=" + this.firstRowIsHeader + ", decimalSeparator=" + this.decimalSeparator + ", thousandsSeparator='" + this.thousandsSeparator + "', dateFormat='" + this.dateFormat + "', timeFormat='" + this.timeFormat + "', datetimeFormat='" + this.datetimeFormat + "', compatibilityMode=" + this.compatibilityMode + ", zeroDateAsNull=" + this.zeroDateAsNull + "}";
    }
}

